#region Operacje wykonywane tylko raz

## Logowanie interaktywne. Użyj -SubscriptionId jeżeli posiadasz kilka subskrypcji.
Add-AzAccount

## Szyfrowanie hasła do aplikacji Azure 
$secPassword = ConvertTo-SecureString -AsPlainText -Force -String '<tutaj wpisz swoje hasło>'

## Tworzenie aplikacji
$myApp = New-AzADApplication -DisplayName AppForServicePrincipal -IdentifierUris 'http://appforserviceprincipal' -Password $secPassword

## Tworzenie usługi głównej
$sp = New-AzADServicePrincipal -ApplicationId $myApp.ApplicationId

## Przypisywanie roli
New-AzRoleAssignment -RoleDefinitionName Contributor -ServicePrincipalName $sp.ServicePrincipalNames[0]

## Zapisywanie zaszyfrowanego hasła na dysku
$azureAppIdPasswordFilePath = 'C:\AzureAppPassword.txt'
$secPassword | ConvertFrom-SecureString | Out-File -FilePath $azureAppIdPasswordFilePath

#endregion

#region Operacje dla każdego skryptu, w którym musisz uwierzytelnić się na platformie Azure

## Utwórz obiekt PSCredential na podstawie identyfikatora aplikacji i hasła
$azureAppCred = (New-Object System.Management.Automation.PSCredential $myApp.ApplicationId, (Get-Content -Path $azureAppIdPasswordFilePath | ConvertTo-SecureString))

## Użyj identyfikatora subskrypcji, identyfikatora użytkownika i hasła do uwierzytelnienia 
$subscription = Get-AzSubscription -SubscriptName '<nazwa subskrypcji>'
Add-AzAccount -ServicePrincipal -SubscriptionId $subscription.Id -TenantId $subscription.TenantId -Credential $azureAppCred
#endregion